import React from 'react'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import { FluidType } from '../../enum/fluidTypes'
import { FrequencyInMonth } from '../../enum/frequency.enum'
import './prices.scss'
import PriceSection from './PriceSection'
const Prices: React.FC = () => {
  return (
    <>
      <div className="header">
        <p className="title pagetitle">Prix des fluides</p>
      </div>
      <div className="prices">
        <PriceSection
          fluid={FluidType.ELECTRICITY}
          frequency={FrequencyInMonth.ELECTRICITY}
        />
        <PriceSection
          fluid={FluidType.WATER}
          frequency={FrequencyInMonth.WATER}
        />
        <PriceSection fluid={FluidType.GAS} frequency={FrequencyInMonth.GAS} />
      </div>
    </>
  )
}

export default Prices
