import React, { useContext } from 'react'
import { Redirect, Route, Switch } from 'react-router-dom'
import { UserContext } from '../../hooks/userContext'
import Consents from '../Consents/Consents'
import Editing from '../Editing/Editing'
import Login from '../Login/Login'
import Prices from '../Prices/Prices'
import Settings from '../Settings/Settings'
import PrivateRoute from './PrivateRoute'

const Routes: React.FC = () => {
  const { user } = useContext(UserContext)

  return (
    <Switch>
      {user && <Redirect path="/login" to="/editing" />}
      <Route path="/login" component={Login} />
      <PrivateRoute path="/editing" component={Editing} exact />
      <PrivateRoute path="/prices" component={Prices} exact />
      <PrivateRoute path="/settings" component={Settings} exact />
      <PrivateRoute path="/consents" component={Consents} exact />
      <Redirect path="*" to="/editing" />
    </Switch>
  )
}

export default Routes
