export interface IConsent
  extends Omit<ConsentEntity, 'CreatedAt' | 'endDate' | 'inseeCode'> {
  startDate: string
  endDate: string
}

export interface ConsentEntity {
  ID: number
  CreatedAt: string
  endDate: string
  firstname: string
  lastname: string
  pointID: number
  address: string
  postalCode: string
  inseeCode: string
}

export interface IConsentPagination
  extends Omit<ConsentPaginationEntity, 'rows'> {
  rows: IConsent[]
}

export interface ConsentPaginationEntity {
  totalRows: number
  totalPages: number
  rows: ConsentEntity[]
}
