import axios from 'axios'
import { toast } from 'react-toastify'
import { IPrice } from '../models/price.model'
export class PricesService {
  /**
   * Save the partnersInfo
   * @param price
   * @param token
   */
  public savePrice = async (price: IPrice, token: string): Promise<void> => {
    try {
      await axios.put(`/api/admin/prices`, price, {
        headers: {
          'XSRF-TOKEN': token,
        },
      })
      toast.success('Price succesfully saved !')
    } catch (e) {
      toast.error('Failed to save price')
      console.error(e)
    }
  }

  /**
   * Gets the prices by fluid
   */
  public getPricesByFluid = async (fluidType: number): Promise<IPrice[]> => {
    try {
      const { data } = await axios.get(`/api/common/prices/${fluidType}`)
      return data
    } catch (e) {
      console.error('error', e)
      return []
    }
  }
}
