import { EditorState, convertFromHTML, ContentState } from 'draft-js'

export const convertStringToEditorState = (string: string): EditorState => {
  const blocksFromHTML = convertFromHTML(string)
  const state = ContentState.createFromBlockArray(
    blocksFromHTML.contentBlocks,
    blocksFromHTML.entityMap
  )
  const editorState = EditorState.createWithContent(state)
  return editorState
}
