import { BrowserRouter } from 'react-router-dom'
import Layout from './components/Layout/Layout'
import Routes from './components/Routes/Routes'
import { UserContext } from './hooks/userContext'
import { ToastContainer } from 'react-toastify'
import 'react-toastify/dist/ReactToastify.css'
import useFindUser from './hooks/useFindUser'

function App() {
  const { user, setUser, isLoading } = useFindUser()

  return (
    <BrowserRouter>
      <UserContext.Provider value={{ user, setUser, isLoading }}>
        <Layout>
          <Routes />
        </Layout>
      </UserContext.Provider>
      <ToastContainer
        progressClassName="toastProgress"
        bodyClassName="toastBody"
      />
    </BrowserRouter>
  )
}
export default App
