import React, { useState } from 'react'
import './dateSelector.scss'
import leftChevron from '../../assets/icons/left-chevron.svg'
import rightChevron from '../../assets/icons/right-chevron.svg'
import Modal from '../Modal/Modal'

interface DateSelectorProps {
  date: Date
  setDate: React.Dispatch<React.SetStateAction<Date>>
  isEmpty: () => boolean
}

const DateSelector: React.FC<DateSelectorProps> = ({
  date,
  setDate,
  isEmpty,
}: DateSelectorProps) => {
  const [openModal, setopenModal] = useState<boolean>(false)
  const [isPrev, setisPrev] = useState<boolean>(false)
  const toggleOpenModal = () => setopenModal((prev) => !prev)

  const handleNextMonth = () => {
    setisPrev(false)
    if (isEmpty() || openModal) {
      const incremented: Date = new Date(date.setMonth(date.getMonth() + 1))
      setDate(incremented)
    } else {
      toggleOpenModal()
    }
  }

  const handlePrevMonth = () => {
    setisPrev(true)
    if (isEmpty() || openModal) {
      const decremented: Date = new Date(date.setMonth(date.getMonth() - 1))
      setDate(decremented)
    } else {
      toggleOpenModal()
    }
  }
  const handleConfirmAlert = () => {
    isPrev ? handlePrevMonth() : handleNextMonth()
    setopenModal(false)
  }
  return (
    <div className="date-selector">
      <img
        src={leftChevron}
        alt="Previous Month"
        onClick={handlePrevMonth}
        className="arrow"
      />
      <div className="text">
        {date.toLocaleString('default', { month: 'long', year: 'numeric' })}
      </div>
      <img
        src={rightChevron}
        alt="Next Month"
        onClick={handleNextMonth}
        className="arrow"
      />
      {openModal && (
        <Modal>
          <>
            <div className="modal-text">
              Attention, vous n'avez pas enregistré vos modifications. Celles-ci
              seront annulées en changeant de mois. Voulez-vous continuer ?
            </div>
            <div className="buttons">
              <button className="btnCancel" onClick={() => setopenModal(false)}>
                Annuler
              </button>
              <button className="btnValid" onClick={handleConfirmAlert}>
                Continuer
              </button>
            </div>
          </>
        </Modal>
      )}
    </div>
  )
}

export default DateSelector
