// import {  } from 'draft-js'
import { stateToHTML } from 'draft-js-export-html'
import { useState } from 'react'
import { Editor, EditorState } from 'react-draft-wysiwyg'
import CustomLink from './CustomLink'
import './customEditor.scss'

interface CustomEditorProps {
  baseState: EditorState
  editorType: 'info' | 'title' | 'content' | 'question' | 'link'
  handleChange: (
    value: string,
    type: 'info' | 'title' | 'content' | 'question' | 'link'
  ) => void
}

const CustomEditor: React.FC<CustomEditorProps> = ({
  baseState,
  handleChange,
  editorType,
}: CustomEditorProps) => {
  const [editorState, setEditorState] = useState<EditorState>(baseState)

  const handleStateChange = (state: EditorState) => {
    setEditorState(state)
    handleChange(stateToHTML(editorState.getCurrentContent()), editorType)
  }

  return (
    <Editor
      editorState={editorState}
      onEditorStateChange={(state) => handleStateChange(state)}
      wrapperClassName="wrapper-class"
      editorClassName="editor-class"
      toolbarClassName="toolbar-class"
      toolbarCustomButtons={[<CustomLink editorState={editorState} />]}
    />
  )
}
export default CustomEditor
