import React, { useEffect, useState } from 'react'
import styles from './layout.module.scss'
import Menu from '../Menu/Menu'
import Navbar from '../Navbar/Navbar'

interface LayoutProps {
  children: React.ReactNode
}

const Layout: React.FC<LayoutProps> = ({ children }: LayoutProps) => {
  const [isMobile, setisMobile] = useState<boolean>(false)
  useEffect(() => {
    function handleResize() {
      const test: boolean =
        /Android|webOS|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(
          navigator.userAgent
        )
          ? true
          : window.innerWidth < 768
          ? true
          : false
      setisMobile(test)
    }
    handleResize()

    window.addEventListener('resize', handleResize)
    return () => {
      window.removeEventListener('resize', handleResize)
    }
  }, [])
  return (
    <div className={styles.root}>
      {!isMobile ? (
        <div className={styles.menuWrapper}>
          <Menu />
        </div>
      ) : (
        <div className={styles.mobileNavWrapper}>
          <Navbar />
        </div>
      )}
      <div className={styles.wrapper}>
        <main>{children}</main>
      </div>
    </div>
  )
}

export default Layout
