import React, { ReactChild } from 'react'
import { createPortal } from 'react-dom'
import './modal.scss'
interface ModalProps {
  children: ReactChild
  classname?: string
}

const Modal: React.FC<ModalProps> = ({ children, classname }: ModalProps) => {
  return createPortal(
    <div className="modal-bg">
      <div className="modal-container">
        <div className={`modal-content ${classname}`}>{children}</div>
      </div>
    </div>,
    document.body
  )
}

export default Modal
