import React from 'react'
import { ContentItems } from '../Editing/Editing'
import { convertStringToEditorState } from '../../utils/editorStateManagment'
import CustomEditor from '../Editing/CustomEditor'
import 'react-draft-wysiwyg/dist/react-draft-wysiwyg.css'
import './monthlyInfo.scss'
import ImagePicker from '../ImagePicker/ImagePicker'
interface MonthlyInfoProps {
  onSave: () => Promise<void>
  onCancel: () => void
  info: string
  handleChange: (
    value: string,
    type: 'info' | 'title' | 'content' | 'question' | 'link' | 'image'
  ) => void
  onDelete: (target: ContentItems) => void
  imageURL: string
}
const MonthlyInfo: React.FC<MonthlyInfoProps> = ({
  onSave,
  onCancel,
  info,
  handleChange,
  onDelete,
  imageURL,
}: MonthlyInfoProps) => {
  return (
    <div className="monthlyInfo">
      <h2>Informations du mois</h2>
      <div>
        <p className="title">Image</p>
        <ImagePicker imageURL={imageURL} handleChange={handleChange} />
        <p className="title">Info</p>
        <CustomEditor
          baseState={convertStringToEditorState(info)}
          handleChange={handleChange}
          editorType="info"
        />
        <div className="buttons">
          <button className="btnCancel" onClick={onCancel}>
            Annuler
          </button>
          <button className="btnValid" onClick={onSave}>
            Sauvegarder
          </button>
          <button className="btnDelete" onClick={() => onDelete('monthlyInfo')}>
            Supprimer
          </button>
        </div>
      </div>
    </div>
  )
}

export default MonthlyInfo
