import React, { useContext } from 'react'
import { Route, Redirect } from 'react-router-dom'
import { UserContext } from '../../hooks/userContext'

interface PrivateRouteProps {
  component: React.FC
  path: string
  exact: boolean
}

const PrivateRoute: React.FC<PrivateRouteProps> = ({
  component,
  path,
  exact,
}: PrivateRouteProps) => {
  const { user } = useContext(UserContext)

  return user ? (
    <Route path={path} exact={exact} component={component} />
  ) : (
    <Redirect to="/login" />
  )
}
export default PrivateRoute
