import { useState, useEffect } from 'react'
import axios from 'axios'
import { User } from '../models/user.model'

const useFindUser = () => {
  const [user, setUser] = useState<User | null>(null)
  const [isLoading, setLoading] = useState<boolean>(true)

  useEffect(() => {
    async function findUser() {
      const { data } = await axios.get(`/api/common/WhoAmI`)
      if (data) {
        setUser(data)
        setLoading(false)
      }
    }
    findUser()
  }, [])
  return {
    user,
    setUser,
    isLoading,
  }
}

export default useFindUser
