import { useState, useEffect } from 'react'
import get from 'lodash/get'
import { Client } from 'cozy-client'

const useInstanceSettings = (client: Client) => {
  const [settings, setSettings] = useState({})
  const [fetchStatus, setFetchStatus] = useState('idle')

  useEffect(() => {
    const fetchData = async () => {
      try {
        const response = await client
          .getStackClient()
          .fetchJSON('GET', '/settings/instance')
        // const response = await client.query(
        //   client.all('io.cozy.settings').getById('instance')
        // )
        setSettings(get(response, 'data.attributes'), {})
        setFetchStatus('loaded')
      } catch (error) {
        setFetchStatus('failed')
      }
    }
    fetchData()
  }, [])

  return {
    data: settings,
    fetchStatus,
  }
}

export default useInstanceSettings
