import { render } from '@testing-library/react'
import React from 'react'
import { Provider } from 'react-redux'
import { createMockEcolyoStore, mockProfileState } from 'tests/__mocks__/store'
import DataShareConsentContent from './DataShareConsentContent'

describe('DataShareConsentContent component', () => {
  it('should be rendered correctly with first connexion text', () => {
    const store = createMockEcolyoStore({
      profile: { ...mockProfileState, isFirstConnection: true },
    })
    const { container } = render(
      <Provider store={store}>
        <DataShareConsentContent />
      </Provider>
    )
    expect(container).toMatchSnapshot()
  })
  it('should be rendered correctly without first connexion text', () => {
    const store = createMockEcolyoStore({
      profile: { ...mockProfileState, isFirstConnection: false },
    })
    const { container } = render(
      <Provider store={store}>
        <DataShareConsentContent />
      </Provider>
    )
    expect(container).toMatchSnapshot()
  })
})
