import { Button, IconButton } from '@material-ui/core'
import { mount } from 'enzyme'
import toJson from 'enzyme-to-json'
import React from 'react'
import { Provider } from 'react-redux'
import * as profileActions from 'store/profile/profile.slice'
import { createMockEcolyoStore } from 'tests/__mocks__/store'
import WelcomeModal from './WelcomeModal'

jest.mock('components/Hooks/useUserInstanceSettings', () => {
  return jest.fn(() => ({
    data: {
      // eslint-disable-next-line camelcase
      public_name: 'mocked_public_name',
    },
  }))
})
jest.mock('services/environment.service', () => {
  return jest.fn(() => ({
    getPublicURL: () => 'https://ecolyo-agent-rec.grandlyon.com',
  }))
})
const mockSendMail = jest.fn()
jest.mock('services/mail.service', () => {
  return jest.fn(() => ({
    SendMail: mockSendMail,
  }))
})
jest.mock('notifications/welcome.hbs', () => {
  return jest.fn(() => ({
    welcomeTemplate: jest.fn(),
  }))
})
jest.mock('mjml-browser', () => {
  return jest.fn(() => ({
    mjml2html: jest.fn(),
  }))
})
jest.mock('services/profile.service')

const updateProfileSpy = jest.spyOn(profileActions, 'updateProfile')

describe('WelcomeModal component', () => {
  beforeEach(() => {
    jest.clearAllMocks()
  })

  const store = createMockEcolyoStore()
  it('should be rendered correctly', () => {
    const component = mount(
      <Provider store={store}>
        <WelcomeModal open={true} />
      </Provider>
    )
    expect(toJson(component)).toMatchSnapshot()
  })

  it('should not be rendered', () => {
    const component = mount(
      <Provider store={store}>
        <WelcomeModal open={false} />
      </Provider>
    )
    expect(toJson(component)).toMatchSnapshot()
  })

  it('should send mail and update profile when user click on the ok button', async () => {
    const component = mount(
      <Provider store={store}>
        <WelcomeModal open={true} />
      </Provider>
    )
    component.find(Button).first().simulate('click')
    expect(mockSendMail).toHaveBeenCalled()
    expect(updateProfileSpy).toHaveBeenCalledWith({
      isFirstConnection: false,
      onboarding: {
        isWelcomeSeen: true,
      },
    })
  })

  it('should send mail and update profile when modal is closed by user', async () => {
    const component = mount(
      <Provider store={store}>
        <WelcomeModal open={true} />
      </Provider>
    )
    component.find(IconButton).first().simulate('click')
    expect(mockSendMail).toHaveBeenCalled()
    expect(updateProfileSpy).toHaveBeenCalledWith({
      isFirstConnection: false,
      onboarding: {
        isWelcomeSeen: true,
      },
    })
  })
})
