import { useI18n } from 'cozy-ui/transpiled/react/providers/I18n'
import React from 'react'
import { useAppSelector } from 'store/hooks'
import './termsView.scss'

const DataShareConsentContent = () => {
  const { t } = useI18n()
  const { isFirstConnection } = useAppSelector(state => state.ecolyo.profile)

  return (
    <div className="dataShare-content-root">
      <div className="dataShare-content-wrapper">
        <h1 className="dataShare-content-title text-22-normal">
          {isFirstConnection
            ? t('dataShare.title1')
            : t('dataShare.title1Update')}
        </h1>
        <p className="text-14-normal">
          {isFirstConnection
            ? t('dataShare.title2')
            : t('dataShare.title2Update')}
        </p>

        <p className="text-14-normal">{t('dataShare.part1')}</p>
        <p className="text-14-normal">{t('dataShare.part2')}</p>
        <p className="text-14-normal">{t('dataShare.part3')}</p>
        <ul className="text-14-normal">
          <li className="text-14-normal">{t('dataShare.item1')}</li>
          <li className="text-14-normal">{t('dataShare.item2')}</li>
          <li className="text-14-normal">{t('dataShare.item3')}</li>
        </ul>
        <p className="text-14-normal">{t('dataShare.part4')}</p>
        <p className="text-14-normal">{t('dataShare.part5')}</p>
        <p className="text-14-normal">{t('dataShare.part6')}</p>
        <p className="text-14-normal">{t('dataShare.part7')}</p>
        <p className="text-14-normal">{t('dataShare.part8')}</p>
        <span className="text-14-normal">{t('dataShare.part9')}</span>
        <span className="text-14-normal">{t('dataShare.part10')}</span>
        <span
          className="text-14-normal"
          dangerouslySetInnerHTML={{ __html: t('dataShare.link1') }}
        />
      </div>
    </div>
  )
}

export default DataShareConsentContent
