import { Button } from '@material-ui/core'
import Dialog from '@material-ui/core/Dialog'
import CloseIcon from 'assets/icons/ico/close.svg'
import StyledIconButton from 'components/CommonKit/IconButton/StyledIconButton'
import LegalNoticeContent from 'components/Options/LegalNotice/LegalNoticeContent'
import { useI18n } from 'cozy-ui/transpiled/react/providers/I18n'
import React from 'react'
import './termsView.scss'

interface LegalNoticeModalProps {
  open: boolean
  handleCloseClick: () => void
}

const LegalNoticeModal = ({
  open,
  handleCloseClick,
}: LegalNoticeModalProps) => {
  const { t } = useI18n()
  return (
    <Dialog
      open={open}
      onClose={handleCloseClick}
      aria-labelledby="accessibility-title"
      classes={{
        root: 'modal-root',
        paper: 'modal-paper',
      }}
    >
      <div id="accessibility-title">{t('legal.title_legal')}</div>
      <StyledIconButton
        icon={CloseIcon}
        onClick={handleCloseClick}
        aria-label={t('feedback.accessibility.button_close')}
        className="modal-paper-close-button"
      />
      <LegalNoticeContent />
      <Button
        aria-label={t('gcu_modal.accessibility.button_accept')}
        onClick={handleCloseClick}
        className="btnPrimary"
      >
        {t('legal.accessibility.button_close')}
      </Button>
    </Dialog>
  )
}

export default LegalNoticeModal
