// @ts-check
const { log, errors } = require('cozy-konnector-libs')
const { findUserPdl } = require('./findUserPdl')
const { getInseeCode } = require('./requests/insee')

/**
 * Verify user identity
 * @param {object} fields
 * @param {string} baseUrl
 * @param {string} apiAuthKey
 * @param {string} loginUtilisateur
 * @returns {Promise<void>}
 */
async function verifyUserIdentity(
  fields,
  baseUrl,
  apiAuthKey,
  loginUtilisateur
) {
  const inseeCode = await getInseeCode(fields.postalCode)

  const pdl = await findUserPdl(
    `${baseUrl}/enedis_SDE_recherche-point/1.0`,
    apiAuthKey,
    loginUtilisateur,
    fields.name,
    fields.address,
    fields.postalCode,
    inseeCode
  )

  if (fields.pointId != pdl) {
    log('error', 'PointId does not match')
    throw errors.LOGIN_FAILED
  }
}

module.exports = { verifyUserIdentity }
