// @ts-check
const { default: axios } = require('axios')
const { log, errors } = require('cozy-konnector-libs')

const API_URL = 'https://apicarto.ign.fr/api/codes-postaux/communes'

/**
 * Return inseeCode given a postalCode
 * @param {string} postalCode
 * @param {string} [city]
 * @return {Promise<string>} inseeCode
 */
async function getInseeCode(postalCode, city) {
  try {
    log('info', `Query getInseeCode for postalCode ${postalCode} / ${city}`)
    const response = await axios.get(`${API_URL}/${postalCode}`)

    if (response.data.length === 1) {
      return response.data[0].codeCommune
    } else {
      if (!city) throw errors.USER_ACTION_NEEDED

      const filteredResponse = response.data.filter(
        town => town.nomCommune.toLowerCase() === city.toLowerCase()
      )
      return filteredResponse[0].codeCommune
    }
  } catch (error) {
    log(
      'error',
      `Query getInseeCode failed for postalCode ${postalCode} / ${city}`
    )
    throw errors.USER_ACTION_NEEDED
  }
}

module.exports = {
  getInseeCode,
}
