// @ts-check
const { log, errors } = require('cozy-konnector-libs')
const {
  getAccountRev,
  getAccountSecret,
  getAccountId,
} = require('./helpers/account')
const { getBoConsent, deleteBoConsent } = require('./requests/bo')
// const { terminateContract } = require('./core/contractTermination')
const { getAccountForDelete } = require('./requests/cozy')
const moment = require('moment')
require('moment-timezone')
moment.locale('fr') // set the language
moment.tz.setDefault('Europe/Paris') // set the timezone
const { isLocal, isAlpha } = require('./helpers/env')
// const ACCOUNT_ID = isLocal() ? 'default_account_id' : 'enedis-sge-grandlyon'

async function onDeleteAccount() {
  log('info', 'Deleting account ...')
  log('info', 'Getting secrets ...')
  const ACCOUNT_ID = getAccountId()
  const accountRev = getAccountRev()

  if (accountRev) {
    log('info', 'Account rev exist')
    const accountData = await getAccountForDelete(ACCOUNT_ID, accountRev)
    // Parse local info for deletion test
    if (isLocal()) {
      log('warn', 'Local run')
      const fields = JSON.parse(
        process.env.COZY_FIELDS ? process.env.COZY_FIELDS : '{}'
      )
      process.env.COZY_FIELDS = JSON.stringify({
        ...fields,
        ...accountData.auth,
      })
    }
    const secrets = getAccountSecret()
    log('info', 'AFTER')
    log('info', accountData)
    const userConsent = await getBoConsent(
      secrets.boBaseUrl,
      secrets.boToken,
      accountData.data.consentId
    )

    log('info', isAlpha())
    if (userConsent.ID && userConsent.pointID) {
      log('log', `Consent ${userConsent.ID} found for user`)
      // Verify if it's dev env to prevent delete of real data
      if (userConsent.serviceID && !isAlpha()) {
        await deleteBoConsent(
          secrets.boBaseUrl,
          secrets.boToken,
          userConsent.ID
        )
        // await terminateContract(
        //   secrets.wso2BaseUrl,
        //   secrets.apiToken,
        //   secrets.sgeLogin,
        //   secrets.contractId,
        //   userConsent.pointID,
        //   userConsent.serviceID
        // )
      } else {
        log('error', `No service id retrieved from BO`)
        throw errors.VENDOR_DOWN
      }
    }

    log('info', 'Deleting account succeed')
  } else {
    log(
      'error',
      'No account revision was found, something went wrong during the deletion of said account'
    )
    throw errors.VENDOR_DOWN
  }
}

onDeleteAccount().then(
  () => {
    log('info', `onDeleteAccount: Successfully delete consent and account.`)
  },
  err => {
    log(
      'error',
      `onDeleteAccount: An error occured during script: ${err.message}`
    )
    throw errors.VENDOR_DOWN
  }
)

module.exports = { onDeleteAccount }
