const { errors } = require('cozy-konnector-libs')
const { verifyUserIdentity } = require('../../src/core/verifyUserIdentity')

jest.mock('../../src/requests/insee', () => ({
  getInseeCode: jest.fn().mockResolvedValue(69),
}))

jest.mock('../../src/core/findUserPdl', () => ({
  findUserPdl: jest.fn().mockResolvedValue('12345'),
}))

jest.mock('../../src/index', () => ({
  start: jest.fn(),
}))

describe('verifyUserIdentity', () => {
  it('should throw LOGIN_FAILED when pdl given and recieved are NOT matching 🚫', async () => {
    try {
      await verifyUserIdentity(
        {
          name: 'John',
          address: '1 street',
          pointId: 987654321,
          postalCode: '69069',
        },
        'azertyuiop',
        'apiKey',
        'login@user.com'
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.LOGIN_FAILED)
    }
  })
  it('should throw TERMS_VERSION_MISMATCH when pdl give and recieved are NOT matching on alternate start 🚫', async () => {
    try {
      await verifyUserIdentity(
        {
          name: 'John',
          address: '1 street',
          pointId: 987654321,
          postalCode: '69069',
        },
        'azertyuiop',
        'apiKey',
        'login@user.com',
        true
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.TERMS_VERSION_MISMATCH)
    }
  })

  it('should return void when pdl give and recieved are matching ✅', async () => {
    expect.assertions(1)
    try {
      await verifyUserIdentity(
        {
          name: 'John',
          address: '1 street',
          pointId: '12345',
          postalCode: '69069',
        },
        'azertyuiop',
        'apiKey',
        'login@user.com'
      )
      expect(true).toBeTruthy()
    } catch (error) {
      expect(true).toBe(false)
    }
  })
})
