// @ts-check
const { log, errors } = require('cozy-konnector-libs')
const soapRequest = require('easy-soap-request')
const { parseTags, parseValue, parseServiceId } = require('../helpers/parsing')
const { commanderCollectePublicationMesures } = require('../requests/sge')
const xml2js = require('xml2js')

/**
 * @param {string} url
 * @param {string} apiAuthKey
 * @param {string} appLogin
 * @param {string} name
 * @param {number} pointId
 * @param {string} startDate
 * @param {string} endDate
 * @return {Promise<number>} User contractId
 */
async function activateContract(
  url,
  apiAuthKey,
  appLogin,
  contractId,
  name,
  pointId,
  startDate,
  endDate
) {
  log('info', 'activateContract')
  const sgeHeaders = {
    'Content-Type': 'text/xml;charset=UTF-8',
    apikey: apiAuthKey,
  }

  const { response } = await soapRequest({
    url: `${url}/enedis_SGE_CommandeCollectePublicationMesures/1.0`,
    headers: sgeHeaders,
    xml: commanderCollectePublicationMesures(
      appLogin,
      contractId,
      pointId,
      name,
      startDate,
      endDate
    ),
  }).catch(err => {
    log('error', 'commanderCollectePublicationMesures')
    log('error', err)
    throw errors.LOGIN_FAILED
  })

  const parsedReply = await xml2js.parseStringPromise(response.body, {
    tagNameProcessors: [parseTags],
    valueProcessors: [parseValue],
    explicitArray: false,
  })

  try {
    return parseServiceId(parsedReply)
  } catch (error) {
    log('error', 'Error while activating contract: ' + error)
    log(
      'error',
      `Enedis issue ${parsedReply.Envelope.Body.Fault.detail.erreur.resultat.$.code}: ${parsedReply.Envelope.Body.Fault.faultstring}`
    )
    //TODO: handle SGT4B8: Il existe déjà plusieurs demandes en cours sur le point ?
    throw errors.LOGIN_FAILED
  }
}

module.exports = { activateContract }
