const { errors } = require('cozy-konnector-libs')
const { getContractStartDate } = require('../../src/core/contractStartDate')
const xml2js = require('xml2js')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

const responseMock = {
  response: {
    body: `<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
    <soap:Body xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
        <ns7:consulterDonneesTechniquesContractuellesResponse xmlns:ns0="http://www.erdf.fr/tube/exposition/finalisation" xmlns:ns7="http://www.enedis.fr/sge/b2b/services/consulterdonneestechniquescontractuelles/v1.0">
            <point id="19160781274487">
                <donneesGenerales>
                    <dateDerniereModificationFormuleTarifaireAcheminement>2021-08-01+02:00</dateDerniereModificationFormuleTarifaireAcheminement>
                    <niveauOuvertureServices>2</niveauOuvertureServices>
                </donneesGenerales>
            </point>
        </ns7:consulterDonneesTechniquesContractuellesResponse>
    </soap:Body>
</soapenv:Envelope>`,
  },
}

const responseIssueMock = {
  response: {
    body: `<?xml version="1.0" encoding="UTF-8"?>
<soapenv:Envelope xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/">
    <soap:Body xmlns:soap="http://schemas.xmlsoap.org/soap/envelope/">
        <ns7:consulterDonneesTechniquesContractuellesResponse xmlns:ns0="http://www.erdf.fr/tube/exposition/finalisation" xmlns:ns7="http://www.enedis.fr/sge/b2b/services/consulterdonneestechniquescontractuelles/v1.0">
            <point id="19160781274487">
            </point>
        </ns7:consulterDonneesTechniquesContractuellesResponse>
    </soap:Body>
</soapenv:Envelope>`,
  },
}

describe('getContractStartDate', () => {
  it('should return void when successfully got contract start date ✅', async () => {
    mockSoapRequest.mockResolvedValueOnce(responseMock)
    expect.assertions(1)
    try {
      await getContractStartDate(
        'http://pouet.com',
        'apiAuthKey',
        'pouet@pouet.com',
        '1111111111'
      )
      expect(true).toBeTruthy()
    } catch (error) {
      expect(true).toBe(false)
    }
  })

  it('should throw VENDOR_DOWN when failing request 🚫', async () => {
    mockSoapRequest.mockRejectedValueOnce('error')

    try {
      await getContractStartDate()
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.VENDOR_DOWN)
    }
  })

  it('should throw NOT_EXISTING_DIRECTORY when failing parsing 🚫', async () => {
    mockSoapRequest.mockResolvedValueOnce(responseIssueMock)
    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
          faultstring: 'Mock error',
        },
      },
    })
    try {
      await getContractStartDate(
        'http://pouet.com',
        'apiAuthKey',
        'pouet@pouet.com',
        '1111111111'
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.NOT_EXISTING_DIRECTORY)
    }
  })
})
