const xml2js = require('xml2js')
const { errors } = require('cozy-konnector-libs')
const { terminateContract } = require('../../src/core/contractTermination')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

const responseMock = {
  response: {
    body: 'mockedBody',
  },
}

describe('terminateContract', () => {
  it('should terminate contract ✅', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)

    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
          faultstring: 'Mock error',
        },
      },
    })
    try {
      const serviceId = await terminateContract(
        'http://test.com',
        '111',
        'login@log.com',
        '1111111111111',
        '1234567'
      )
      expect(serviceId).toEqual({
        Envelope: {
          Body: {
            Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
            faultstring: 'Mock error',
          },
        },
      })
    } catch (error) {
      expect(error.message).toBe(errors.VENDOR_DOWN)
    }
  })
  it('should throw VENDOR_DOWN on bad request🚫', async () => {
    mockSoapRequest.mockRejectedValueOnce('reject')

    try {
      await terminateContract(
        'http://test.com',
        '111',
        'login@log.com',
        '1111111111111',
        '1234567'
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error.message).toBe(errors.VENDOR_DOWN)
    }
  })
  it('should throw VENDOR_DOWN 🚫', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)

    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          Fault: {},
        },
      },
    })

    try {
      await terminateContract(
        'http://test.com',
        '111',
        'login@log.com',
        '1111111111111',
        '1234567'
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error.message).toBe(errors.VENDOR_DOWN)
    }
  })
})
