const { log } = require('cozy-konnector-libs')

/**
 * Throw an error if the response contains a  "Request Rejected"
 * Enedis might send a 429 status but the F5 always transform it to a 200
 * @param {string} response
 * @example <html><head><title>Request Rejected</title></head>
 * <body>The requested URL was rejected. Please consult with your administrator</body></html>
 */
function catchRequestReject(response) {
  if (response.includes('Request Rejected')) {
    const supportID = response.replace(/\D/g, '')
    log('debug', response.slice(0, 100))
    log('error', `Support ID : ${supportID}`)
    log('error', 'Request Rejected')
    throw new Error('Request Rejected')
  }
}

module.exports = { catchRequestReject }
