const { buildAgregatedData } = require('../../src/helpers/aggregate')
const { cozyClient } = require('cozy-konnector-libs')

describe('buildAgregatedData', () => {
  it('should return empty', async () => {
    const reply = await buildAgregatedData([], 'com.enedis.day')
    expect(reply).toEqual([])
  })
  it('should return year value', async () => {
    const reply = await buildAgregatedData(
      {
        '2022': 36,
      },
      'com.grandlyon.enedis.year'
    )
    expect(reply).toEqual([
      {
        day: 0,
        hour: 0,
        load: 36,
        minute: 0,
        month: 1,
        year: 2022,
      },
    ])
  })
  it('should return year value with doc existing', async () => {
    const spy = jest.spyOn(cozyClient.data, 'findAll')
    spy.mockResolvedValueOnce([{ year: 2022, month: 8, day: 1, load: 1 }])
    const reply = await buildAgregatedData(
      {
        '2022': 36,
      },
      'com.grandlyon.enedis.year'
    )
    expect(reply).toEqual([
      {
        day: 0,
        hour: 0,
        load: 37,
        minute: 0,
        month: 1,
        year: 2022,
      },
    ])
  })
  it('should return month value', async () => {
    const spy = jest.spyOn(cozyClient.data, 'findAll')
    spy.mockResolvedValueOnce([{ year: 2022, month: 8, day: 1, load: 1 }])
    const reply = await buildAgregatedData(
      {
        '2022-08': 36,
      },
      'com.grandlyon.enedis.month'
    )
    expect(reply).toEqual([
      {
        day: 0,
        hour: 0,
        load: 37,
        minute: 0,
        month: 8,
        year: 2022,
      },
    ])
  })
  it('should return daily value', async () => {
    const spy = jest.spyOn(cozyClient.data, 'findAll')
    spy.mockResolvedValueOnce([
      { year: 2022, month: 8, day: 1, load: 1, hour: 13 },
    ])
    const reply = await buildAgregatedData(
      {
        '2022-08-01-13:39:25+00:00': 36,
      },
      'com.grandlyon.enedis.minute'
    )
    expect(reply).toEqual([
      {
        day: 1,
        hour: 13,
        load: 37,
        minute: 0,
        month: 8,
        year: 2022,
      },
    ])
  })
})
