const {
  parseUserPdl,
  parseContractStartDate,
  parseContracts,
  parseServiceId,
  parseSgeXmlData,
  formateDataForDoctype,
  parseTags,
  parseValue,
} = require('../../src/helpers/parsing')
describe('parsing', () => {
  it('should parse userPdl', () => {
    const result = {
      Envelope: {
        Body: {
          rechercherPointResponse: { points: { point: { $: { id: 1 } } } },
        },
      },
    }
    const reply = parseUserPdl(result)
    expect(reply).toEqual(1)
  })
  it('should parse contract start date', () => {
    const result = {
      Envelope: {
        Body: {
          consulterDonneesTechniquesContractuellesResponse: {
            point: {
              donneesGenerales: {
                dateDerniereModificationFormuleTarifaireAcheminement:
                  '01/01/2022',
              },
            },
          },
        },
      },
    }
    const reply = parseContractStartDate(result)
    expect(reply).toEqual('01/01/2022')
  })
  it('should parse contract', () => {
    const result = {
      Envelope: {
        Body: {
          rechercherServicesSouscritsMesuresResponse: {
            servicesSouscritsMesures: {
              serviceSouscritMesures: [
                {
                  serviceSouscritId: 78232791,
                  etatCode: 'TERMINE',
                  serviceSouscritLibelle:
                    'Collecte de la courbe de charge au pas 30 min avec transmission quotidienne des données brutes en soutirage',
                },
                {
                  serviceSouscritId: 78232793,
                  etatCode: 'TERMINE',
                  serviceSouscritLibelle:
                    'Collecte de la courbe de charge au pas 30 min avec transmission quotidienne des données brutes en soutirage',
                },
              ],
            },
          },
        },
      },
    }
    const reply = parseContracts(result)
    expect(reply).toEqual([
      {
        serviceSouscritId: 78232791,
        etatCode: 'TERMINE',
        serviceSouscritLibelle:
          'Collecte de la courbe de charge au pas 30 min avec transmission quotidienne des données brutes en soutirage',
      },
      {
        serviceSouscritId: 78232793,
        etatCode: 'TERMINE',
        serviceSouscritLibelle:
          'Collecte de la courbe de charge au pas 30 min avec transmission quotidienne des données brutes en soutirage',
      },
    ])
  })

  it('should parse service id', () => {
    const result = {
      Envelope: {
        Body: {
          commanderCollectePublicationMesuresResponse: {
            serviceSouscritId: 12,
          },
        },
      },
    }
    const reply = parseServiceId(result)
    expect(reply).toEqual(12)
  })
  it('should parse consumption data', () => {
    const result = {
      Envelope: {
        Body: {
          consulterMesuresDetailleesResponse: {
            grandeur: {
              mesure: {
                v: 14361,
                d: '2021-08-01T00:00:00.000+02:00',
              },
            },
          },
        },
      },
    }
    const reply = parseSgeXmlData(result)
    expect(reply).toEqual({
      v: 14361,
      d: '2021-08-01T00:00:00.000+02:00',
    })
  })
  it('should format data for doctype', async () => {
    const data = [
      {
        v: 14361,
        d: '2021-08-01T00:00:00.000+02:00',
      },
      {
        v: 11,
        d: '2021-08-02T00:00:00.000+02:00',
      },
    ]
    const reply = await formateDataForDoctype(data)
    expect(reply).toEqual([
      { day: 1, hour: 0, load: 14361, minute: 0, month: 8, year: 2021 },
      { day: 2, hour: 0, load: 11, minute: 0, month: 8, year: 2021 },
    ])
  })

  it('should parseTag with :', () => {
    const reply = parseTags('test:tag')
    expect(reply).toBe('tag')
  })
  it('should parseTag', () => {
    const reply = parseTags('testtag')
    expect(reply).toBe('testtag')
  })

  it('should parse value from Wh to KWh', () => {
    const reply = parseValue(14361, 'v')
    expect(reply).toBe(14.36)
  })
  it('should not parse value', () => {
    const reply = parseValue(14361, 'w')
    expect(reply).toBe(14361)
  })
})
