const xml2js = require('xml2js')
const { errors } = require('cozy-konnector-libs')
const { findUserPdl } = require('../../src/core/findUserPdl')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValue({
  Envelope: {
    Body: {
      Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
      faultstring: 'Mock error',
    },
  },
})

const mockParseUserPdl = jest.fn()
jest.mock('../../src/helpers/parsing', () => ({
  parseUserPdl: () => mockParseUserPdl(),
}))

const responseMock = {
  response: {
    body: 'mockedBody',
  },
}

describe('recherchePoint', () => {
  it('should throw LOGIN_FAILED for too many responses', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)
    mockParseUserPdl.mockImplementationOnce(() => {
      throw new Error('Error')
    })

    try {
      await findUserPdl()
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.LOGIN_FAILED)
    }
  })

  it('should throw LOGIN_FAIL if soapRequest fails', async () => {
    mockSoapRequest.mockRejectedValueOnce('reject')
    try {
      await findUserPdl()
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.LOGIN_FAILED)
    }
  })

  it('should return a correct pdl number', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)
    mockParseUserPdl.mockResolvedValue('12345')

    expect(await findUserPdl()).toBe('12345')
  })
})
