const { log, updateOrCreate } = require('cozy-konnector-libs')
const { isLocal } = require('../helpers/env')
const cozyClient = require('cozy-konnector-libs/dist/libs/cozyclient')

async function saveAccountData(accountId, accountData) {
  log('info', `saveAccountData: ${accountId}`)

  let account = await getAccount(accountId)

  account = await updateOrCreate(
    [{ ...account, data: accountData }],
    'io.cozy.accounts'
  )
  return account
}

async function getAccount(accountId) {
  log('info', `getAccount: ${accountId}`)
  const accounts = await cozyClient.data.findAll('io.cozy.accounts')
  return accounts.filter(account =>
    isLocal() ? account._id === accountId : account.account_type === accountId
  )[0]
}

async function getAccountForDelete(accountId, accountRev) {
  log('info', `getAccountForDelete: ${accountId} ${accountRev}`)
  const body = await cozyClient.fetchJSON(
    'GET',
    `/data/io.cozy.accounts/${accountId}?rev=${accountRev}`
  )

  log('debug', `getAccountForDelete: ${body}`)
  return body
}

module.exports = { getAccount, saveAccountData, getAccountForDelete }
