const xml2js = require('xml2js')
const { errors } = require('cozy-konnector-libs')
const { findUserAddress } = require('../../src/core/findUserAddress')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValue({
  Envelope: {
    Body: {
      Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
      faultstring: 'Mock error',
    },
  },
})

const mockParseUserPdl = jest.fn()
const mockParseUserAddress = jest.fn()
jest.mock('../../src/helpers/parsing', () => ({
  parseUserPdl: () => mockParseUserPdl(),
  parseUserAddress: () => mockParseUserAddress(),
}))

const responseMock = {
  response: {
    body: 'mockedBody',
  },
}

describe('findUserAddress', () => {
  it('should throw VENDOR_DOWN if soapRequest fails', async () => {
    mockSoapRequest.mockRejectedValueOnce('reject')
    try {
      await findUserAddress()
      expect(true).toBe(false)
    } catch (error) {
      expect(error.message).toBe(errors.VENDOR_DOWN)
    }
  })

  it('should throw VENDOR_DOWN if parsing user address fails', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)
    mockParseUserAddress.mockImplementation(() => {
      throw new Error('error')
    })

    try {
      await findUserAddress()
      expect(true).toBe(false)
    } catch (error) {
      expect(error.message).toBe(errors.VENDOR_DOWN)
    }
  })
})
