const xml2js = require('xml2js')
const { errors } = require('cozy-konnector-libs')
const { activateContract } = require('../../src/core/contractActivation')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

const mockParseServiceId = jest.fn()
jest.mock('../../src/helpers/parsing', () => ({
  parseServiceId: () => mockParseServiceId(),
}))

const responseMock = {
  response: {
    body: 'mockedBody',
  },
}

describe('activateContract', () => {
  it('should return last contract if there is multiple contract ✅', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)
    mockParseServiceId.mockReturnValue(78232791)

    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({})

    try {
      const serviceId = await activateContract(
        'http://test.com',
        '111',
        'login@log.com',
        '1234567',
        'POUET',
        '1111111111111',
        '01/01/2022',
        '01/01/2023'
      )
      expect(serviceId).toBe(78232791)
    } catch (error) {
      expect(error.message).toBe(errors.CAPTCHA_RESOLUTION_FAILED)
    }

    mockParseServiceId.mockRestore()
  })
  it('should throw CAPTCHA_RESOLUTION_FAILED when request fail 🚫', async () => {
    mockSoapRequest.mockRejectedValueOnce('reject')
    try {
      await activateContract(
        'http://test.com',
        '111',
        'login@log.com',
        '1234567',
        'POUET',
        '1111111111111',
        '01/01/2022',
        '01/01/2023'
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error.message).toBe(errors.CAPTCHA_RESOLUTION_FAILED)
    }

    mockParseServiceId.mockRestore()
  })
  it('should throw CAPTCHA_RESOLUTION_FAILED when failing parsing 🚫', async () => {
    mockSoapRequest.mockResolvedValueOnce(responseMock)
    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
          faultstring: 'Mock error',
        },
      },
    })
    mockParseServiceId.mockImplementationOnce(() => {
      throw new Error('error')
    })
    try {
      await activateContract(
        'http://test.com',
        '111',
        'login@log.com',
        '1234567',
        'POUET',
        '1111111111111',
        '01/01/2022',
        '01/01/2023'
      )
      expect(true).toBe(false)
    } catch (error) {
      expect(error.message).toBe(errors.CAPTCHA_RESOLUTION_FAILED)
    }

    mockParseServiceId.mockRestore()
  })
})
