// @ts-check
const { log, errors } = require('cozy-konnector-libs')
const { findUserPdl } = require('./findUserPdl')
const { getInseeCode } = require('../requests/insee')

/**
 * Verify user identity
 * @param {object} fields
 * @param {string} baseUrl
 * @param {string} apiAuthKey
 * @param {string} loginUtilisateur
 * @param {boolean} isAlternateStart
 * @returns {Promise<User>}
 */
async function verifyUserIdentity(
  fields,
  baseUrl,
  apiAuthKey,
  loginUtilisateur,
  isAlternateStart = false,
  inseeCode = ''
) {
  // If first start get InseeCode
  log('debug', 'verifyUserIdentity')
  if (!isAlternateStart) {
    inseeCode = await getInseeCode(fields.postalCode, fields.city)
  }

  const pdl = await findUserPdl(
    `${baseUrl}/enedis_SDE_recherche-point/1.0`,
    apiAuthKey,
    loginUtilisateur,
    fields.lastname,
    fields.address,
    fields.postalCode,
    inseeCode
  )

  if (fields.pointId != pdl) {
    log('error', 'PointId does not match')
    if (isAlternateStart) {
      throw errors.TERMS_VERSION_MISMATCH
    } else {
      throw errors.LOGIN_FAILED
    }
  }

  return {
    lastname: fields.lastname,
    firstname: fields.firstname,
    pointId: fields.pointId,
    inseeCode,
    postalCode: fields.postalCode,
    address: fields.address,
  }
}

module.exports = { verifyUserIdentity }
