const { errors } = require('cozy-konnector-libs')
const { getInseeCode } = require('../../src/requests/insee')
describe('getInseeCode', () => {
  it('should return a valid insee code for Lyon 7', async () => {
    expect(await getInseeCode(69007)).toEqual('69387')
  })

  it('should throw USER_ACTION_NEEDED for a unexisting post code', async () => {
    try {
      await getInseeCode(69069)
    } catch (error) {
      expect(error).toEqual(errors.USER_ACTION_NEEDED)
    }
  })

  it('should throw USER_ACTION_NEEDED for post code 69290 when city is not provided', async () => {
    try {
      await getInseeCode(69290)
    } catch (error) {
      expect(error).toEqual(errors.USER_ACTION_NEEDED)
    }
  })

  it('should return Craponne insee code for post code 69290', async () => {
    expect(await getInseeCode(69290, 'CRAPONNE')).toEqual('69069')
  })

  it('should return Pollionnay insee code for post code 69290', async () => {
    expect(await getInseeCode(69290, 'POLLIONNAY')).toEqual('69154')
  })
})
