const { log } = require('cozy-konnector-libs')
const { iSLocal } = require('./env')

function getAccountId() {
  log('info', `getAccountId`)
  try {
    return JSON.parse(process.env.COZY_FIELDS).account
  } catch (err) {
    throw new Error(`You must provide 'account' in COZY_FIELDS: ${err.message}`)
  }
}

function getAccountRev() {
  log('info', `getAccountRev`)
  try {
    return iSLocal()
      ? 'fakeAccountRev'
      : JSON.parse(process.env.COZY_FIELDS).account_rev
  } catch (err) {
    throw new Error(`You must provide 'account' in COZY_FIELDS: ${err.message}`)
  }
}

/**
 * Return account secrets.
 * For local testing, change value with values from your konnector-dev-config.json
 */
function getAccountSecret() {
  try {
    return iSLocal()
      ? {
          baseUrl: 'https://test.fr',
          sgeLogin: 'test@test.com',
          contractId: '134567',
          boBaseUrl: 'https://botest.grandlyon.com/',
          boToken: 'tok31n',
          apiAuthKey: 'authkeYeasqqd56dsdq',
        }
      : JSON.parse(process.env.COZY_PARAMETERS).secret
  } catch (err) {
    throw new Error(
      `You must provide 'account-types' in COZY_PARAMETERS: ${err.message}`
    )
  }
}
module.exports = { getAccountId, getAccountRev, getAccountSecret }
