const { log, errors } = require('cozy-konnector-libs')
const { getAccountRev, getAccountSecret } = require('./helpers/account')
const { getBoConsent, deleteBoConsent } = require('./requests/bo')
const { terminateContract } = require('./core/contractTermination')
const { getAccount } = require('./requests/cozy')
// const getAccountSecret = require('./helpers/getAccountSecret')
const moment = require('moment')
require('moment-timezone')
moment.locale('fr') // set the language
moment.tz.setDefault('Europe/Paris') // set the timezone
const { iSLocal } = require('./helpers/env')
const ACCOUNT_ID = iSLocal() ? 'default_account_id' : 'enedis-sge-grandlyon'

async function onDeleteAccount() {
  log('info', 'Deleting account ...')
  log('info', 'Getting secrets ...')
  const secrets = getAccountSecret()
  const accountRev = getAccountRev()

  if (accountRev) {
    log('info', 'Account rev exist')
    const accountData = await getAccount(ACCOUNT_ID)
    const userConsent = await getBoConsent(
      secrets.boBaseUrl,
      secrets.boToken,
      accountData.data.consentId
    )

    if (userConsent.pointId && userConsent.pointId) {
      log('error', `Consent found for user`)
      if (userConsent.serviceId) {
        await deleteBoConsent(
          secrets.boBaseUrl,
          secrets.boToken,
          userConsent.id
        )
        await terminateContract(
          secrets.baseUrl,
          secrets.apiAuthKey,
          secrets.sgeLogin,
          secrets.contractId,
          userConsent.pointId,
          userConsent.serviceId
        )
      } else {
        log('error', `No service id retrieved from BO`)
        throw errors.VENDOR_DOWN
      }
    }

    log('info', 'Deleting account succeed')
  } else {
    log(
      'error',
      'No account revision was found, something went wrong during the deletion of said account'
    )
    throw errors.VENDOR_DOWN
  }
}

onDeleteAccount().then(
  () => {
    log('info', `onDeleteAccount: Successfully delete consent and account.`)
  },
  err => {
    log(
      'error',
      `onDeleteAccount: An error occured during script: ${err.message}`
    )
    throw errors.VENDOR_DOWN
  }
)

module.exports = { onDeleteAccount }
