const xml2js = require('xml2js')
const { errors } = require('cozy-konnector-libs')
const { findUserAddress } = require('../../src/core/findUserAddress')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValue({
  Envelope: {
    Body: {
      Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
      faultstring: 'Mock error',
    },
  },
})

const mockParseUserPdl = jest.fn()
jest.mock('../../src/helpers/parsing', () => ({
  parseUserPdl: () => mockParseUserPdl(),
}))

const responseMock = {
  response: {
    body: 'mockedBody',
  },
}

describe('findUserAddress', () => {
  it('should throw LOGIN_FAIL if soapRequest fails', async () => {
    mockSoapRequest.mockRejectedValueOnce('reject')
    try {
      await findUserAddress()
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.VENDOR_DOWN)
    }
  })

  it('should return a correct pdl number', async () => {
    mockSoapRequest.mockResolvedValue(responseMock)
    mockParseUserPdl.mockResolvedValue('12345')

    try {
      await findUserAddress()
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.NOT_EXISTING_DIRECTORY)
    }
  })
})
