const xml2js = require('xml2js')
const { errors } = require('cozy-konnector-libs')
const { findUserPdl } = require('../../src/core/findUserPdl')

const mockSoapRequest = jest.fn()
jest.mock('easy-soap-request', () => async () => mockSoapRequest())

const responseMock = {
  response: {
    body: 'mockedBody',
  },
}

describe('recherchePoint', () => {
  afterEach(() => {
    jest.clearAllMocks()
  })

  it('should throw LOGIN_FAIL if soapRequest fails', async () => {
    const mockParseUserPdl = jest.fn()
    jest.mock('../../src/helpers/parsing', () => ({
      parseUserPdl: () => mockParseUserPdl(),
    }))
    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          Fault: { detail: { erreur: { resultat: { $: { code: 401 } } } } },
          faultstring: 'Mock error',
        },
      },
    })
    mockSoapRequest.mockRejectedValueOnce('reject')
    try {
      await findUserPdl()
      expect(true).toBe(false)
    } catch (error) {
      expect(error).toBe(errors.LOGIN_FAILED)
    }
  })

  it('should return a correct pdl number', async () => {
    const mockParseUserPdl = jest.fn()
    jest.mock('../../src/helpers/parsing', () => ({
      parseUserPdl: () => mockParseUserPdl(),
    }))
    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          rechercherPointResponse: {
            points: { point: { $: { id: '191919119' } } },
          },
        },
      },
    })
    mockSoapRequest.mockResolvedValueOnce(responseMock)

    expect(await findUserPdl()).toBe('191919119')
  })

  it('should handle issue on parsing', async () => {
    const cozyKonnectorsLib = require('cozy-konnector-libs')
    const spyer = jest.spyOn(cozyKonnectorsLib, 'log')
    jest.spyOn(xml2js, 'parseStringPromise').mockResolvedValueOnce({
      Envelope: {
        Body: {
          Fault: {
            detail: {
              erreur: {
                resultat: {
                  $: {
                    code: 401,
                  },
                },
              },
            },
          },
        },
      },
    })
    mockSoapRequest.mockResolvedValueOnce(responseMock)

    await findUserPdl()
    // Only verifing that we are going through logs
    expect(spyer).toBeCalledTimes(3)
  })
})
