const {
  aggregateMonthlyLoad,
  aggregateYearlyLoad,
} = require('../../src/helpers/aggregate')

describe('aggregateMonthlyLoad', () => {
  it('should aggregate monthly load', () => {
    const data = [
      { year: 2024, month: 1, day: 29, hour: 0, minute: 0, load: 1, price: 2 },
      { year: 2024, month: 1, day: 30, hour: 0, minute: 0, load: 1, price: 2 },
      { year: 2024, month: 1, day: 31, hour: 0, minute: 0, load: 1, price: 2 },
      { year: 2024, month: 2, day: 1, hour: 0, minute: 0, load: 1, price: 2 },
    ]

    const result = aggregateMonthlyLoad(data)

    expect(result).toStrictEqual([
      { year: 2024, month: 1, day: 0, hour: 0, minute: 0, load: 3, price: 6 },
      { year: 2024, month: 2, day: 0, hour: 0, minute: 0, load: 1, price: 2 },
    ])
  })
})

describe('aggregateYearlyLoad', () => {
  it('should aggregate yearly load', () => {
    const data = [
      { year: 2023, month: 12, day: 0, hour: 0, minute: 0, load: 1, price: 2 },
      { year: 2024, month: 1, day: 0, hour: 0, minute: 0, load: 1, price: 2 },
      { year: 2024, month: 2, day: 0, hour: 0, minute: 0, load: 1, price: 2 },
    ]

    const result = aggregateYearlyLoad(data)

    expect(result).toStrictEqual([
      { year: 2023, month: 0, day: 0, hour: 0, minute: 0, load: 1, price: 2 },
      { year: 2024, month: 0, day: 0, hour: 0, minute: 0, load: 2, price: 4 },
    ])
  })
})
