const xml2js = require('xml2js')
const { parseTags, parseValue } = require('../../src/helpers/parsing')
const {
  consultationMesuresDetaillees,
  consultationMesuresDetailleesMaxPower,
  consulterDonneesTechniquesContractuelles,
  rechercherPoint,
  rechercherServicesSouscritsMesures,
  commanderCollectePublicationMesures,
  commanderArretServiceSouscritMesures,
} = require('../../src/requests/sge')

describe('Sge routes', () => {
  describe('consultationMesuresDetaillees', () => {
    it('should format request with default params', async () => {
      const reply = consultationMesuresDetaillees(
        1111,
        'test@grandlyon.com',
        '2022-08-01',
        '2022-08-20'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })
      const data =
        parsedReply.Envelope.Body.consulterMesuresDetailleesV3.demande
      expect(Object.keys(data).length).toEqual(9)
      expect(data.mesuresTypeCode).toEqual('ENERGIE')
      expect(data.grandeurPhysique).toEqual('EA')
    })
    it('should format request with given mesure type and unit', async () => {
      const reply = consultationMesuresDetaillees(
        1111,
        'test@grandlyon.com',
        '2022-08-01',
        '2022-08-20',
        'mesurePouet',
        'POUET'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })
      const data =
        parsedReply.Envelope.Body.consulterMesuresDetailleesV3.demande
      expect(Object.keys(data).length).toEqual(9)
      expect(data.mesuresTypeCode).toEqual('mesurePouet')
      expect(data.grandeurPhysique).toEqual('POUET')
    })
  })
  describe('consultationMesuresDetailleesMaxPower', () => {
    it('should format request with default params', async () => {
      const reply = consultationMesuresDetailleesMaxPower(
        1111,
        'test@grandlyon.com',
        '2022-08-01',
        '2022-08-20'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })
      const data =
        parsedReply.Envelope.Body.consulterMesuresDetailleesV3.demande
      expect(Object.keys(data).length).toEqual(10)
      expect(data.mesuresPas).toEqual('P1D')
      expect(data.mesuresTypeCode).toEqual('PMAX')
      expect(data.grandeurPhysique).toEqual('PMA')
    })
    it('should format request with given mesure type and unit', async () => {
      const reply = consultationMesuresDetailleesMaxPower(
        1111,
        'test@grandlyon.com',
        '2022-08-01',
        '2022-08-20',
        'mesurePouet',
        'POUET'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })
      const data =
        parsedReply.Envelope.Body.consulterMesuresDetailleesV3.demande
      expect(Object.keys(data).length).toEqual(10)
      expect(data.mesuresTypeCode).toEqual('mesurePouet')
      expect(data.grandeurPhysique).toEqual('POUET')
    })
  })
  describe('consulterDonneesTechniquesContractuelles', () => {
    it('should format request', async () => {
      const reply = consulterDonneesTechniquesContractuelles(
        1111,
        'test@grandlyon.com'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })
      const data =
        parsedReply.Envelope.Body.consulterDonneesTechniquesContractuelles
      expect(Object.keys(data).length).toEqual(3)
      expect(data.autorisationClient).toEqual('true')
    })
  })
  describe('rechercherPoint', () => {
    it('should format request', async () => {
      const reply = rechercherPoint(
        'test@grandlyon.com',
        'toto',
        '69007',
        '69387',
        '20 rue du lac'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })
      const data = parsedReply.Envelope.Body
      expect(Object.keys(data.rechercherPoint).length).toEqual(2)
      expect(Object.keys(data.rechercherPoint.criteres).length).toEqual(3)
      expect(
        Object.keys(data.rechercherPoint.criteres.adresseInstallation).length
      ).toEqual(3)
      expect(data.rechercherPoint.criteres.rechercheHorsPerimetre).toEqual(
        'true'
      )
    })
  })
  describe('rechercherServicesSouscritsMesures', () => {
    it('should format request', async () => {
      const reply = rechercherServicesSouscritsMesures(
        'test@grandlyon.com',
        '69007',
        1111233
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })

      const data = parsedReply.Envelope.Body
      expect(
        Object.keys(data.rechercherServicesSouscritsMesures).length
      ).toEqual(2)
      expect(
        Object.keys(data.rechercherServicesSouscritsMesures.criteres).length
      ).toEqual(2)
    })
  })
  describe('commanderCollectePublicationMesures', () => {
    it('should format request', async () => {
      const reply = commanderCollectePublicationMesures(
        'test@grandlyon.com',
        '12345',
        '1111233',
        'toto',
        '2021-08-01',
        '2021-08-02'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })

      const data = parsedReply.Envelope.Body
      expect(
        Object.keys(data.commanderCollectePublicationMesures.demande).length
      ).toEqual(2)
      expect(
        Object.keys(
          data.commanderCollectePublicationMesures.demande.donneesGenerales
        ).length
      ).toEqual(4)
      expect(
        Object.keys(
          data.commanderCollectePublicationMesures.demande.accesMesures
        ).length
      ).toEqual(10)
      expect(
        Object.keys(
          data.commanderCollectePublicationMesures.demande.accesMesures
            .declarationAccordClient
        ).length
      ).toEqual(2)
    })
  })
  describe('commanderArretServiceSouscritMesures', () => {
    it('should format request', async () => {
      const reply = commanderArretServiceSouscritMesures(
        'test@grandlyon.com',
        '12345',
        '1111233',
        '3654'
      )
      const parsedReply = await xml2js.parseStringPromise(reply, {
        tagNameProcessors: [parseTags],
        valueProcessors: [parseValue],
        explicitArray: false,
      })

      const data = parsedReply.Envelope.Body
      expect(
        Object.keys(data.commanderArretServiceSouscritMesures.demande).length
      ).toEqual(2)
      expect(
        Object.keys(
          data.commanderArretServiceSouscritMesures.demande.donneesGenerales
        ).length
      ).toEqual(4)
      expect(
        Object.keys(
          data.commanderArretServiceSouscritMesures.demande.arretServiceSouscrit
        ).length
      ).toEqual(1)
    })
  })
})
