const REPLACE_CHARS = {
  â: 'a',
  ê: 'e',
  î: 'i',
  ô: 'o',
  û: 'u',
  ä: 'a',
  ë: 'e',
  ï: 'i',
  ö: 'o',
  ü: 'u',
  é: 'e',
  à: 'a',
  è: 'e',
  ç: 'c',
}

/**
 * Clean lastname input and remove all accents but not ʼ, ', -
 * @param {string} lastname
 * @return {string} lastnameSanitized
 */
function sanitizeLastname(lastname) {
  return lastname
    .toLowerCase()
    .replace(/[âêîôûäëïöüéàèç]/g, match => REPLACE_CHARS[match])
    .trim()
}

module.exports = { sanitizeLastname }
