// @ts-check
const { log, errors } = require('cozy-konnector-libs')
const {
  getAccountRev,
  getAccountSecret,
  getAccountId,
} = require('./helpers/account')
const { getBoConsent, deleteBoConsent } = require('./requests/bo')
const { terminateContract } = require('./core/contractTermination')
const { getAccountForDelete } = require('./requests/cozy')
const moment = require('moment')
require('moment-timezone')
moment.locale('fr') // set the language
moment.tz.setDefault('Europe/Paris') // set the timezone
const { isLocal, isDev } = require('./helpers/env')

async function onDeleteAccount() {
  log('info', 'Deleting account ...')
  log('info', 'Getting secrets ...')
  const ACCOUNT_ID = getAccountId()
  const accountRev = getAccountRev()

  if (accountRev) {
    log('info', 'Account rev exist')
    const accountData = await getAccountForDelete(ACCOUNT_ID, accountRev)
    // Parse local info for deletion test
    if (isLocal()) {
      log('warn', 'Local run')
      const fields = JSON.parse(
        process.env.COZY_FIELDS ? process.env.COZY_FIELDS : '{}'
      )
      process.env.COZY_FIELDS = JSON.stringify({
        ...fields,
        ...accountData.auth,
      })
    }
    const secrets = getAccountSecret()

    const userConsent = await getBoConsent(
      secrets.boBaseUrl,
      secrets.boToken,
      accountData.data.consentId
    )

    log('info', `isAlpha: ${isDev()}`)
    log('info', `userConsent: ${JSON.stringify(userConsent)}`)
    if (userConsent.ID && userConsent.pointID) {
      log('log', `Consent ${userConsent.ID} found for user`)
      if (userConsent.serviceID) {
        await deleteBoConsent(
          secrets.boBaseUrl,
          secrets.boToken,
          userConsent.ID
        )
        // Verify if it's dev env to prevent delete of real data
        if (!isDev()) {
          await terminateContract(
            secrets.wso2BaseUrl,
            secrets.apiToken,
            secrets.sgeLogin,
            secrets.contractId,
            userConsent.pointID,
            userConsent.serviceID
          )
        }
      } else {
        log('error', `No service id retrieved from BO`)
        throw errors.VENDOR_DOWN
      }
    }

    log('info', 'Deleting account succeed')
  } else {
    log(
      'error',
      'No account revision was found, something went wrong during the deletion of said account'
    )
    throw errors.VENDOR_DOWN
  }
}

onDeleteAccount().then(
  () => {
    log('info', `onDeleteAccount: Successfully delete consent and account.`)
  },
  err => {
    log(
      'error',
      `onDeleteAccount: An error occured during script: ${err.message}`
    )
    throw errors.VENDOR_DOWN
  }
)

module.exports = { onDeleteAccount }
