const { isDev } = require('../../src/helpers/env')
describe('isAlpha', () => {
  const OLD_ENV = process.env

  beforeEach(() => {
    jest.resetModules() // Most important - it clears the cache
    process.env = { ...OLD_ENV } // Make a copy
  })

  afterAll(() => {
    process.env = OLD_ENV // Restore old environment
  })

  it('should return false for local', () => {
    // Set the variables
    process.env.COZY_URL = 'http://cozy.tools:8080'
    const reply = isDev()
    expect(reply).toBe(true)
  })
  it('should return false for prod URL', () => {
    // Set the variables
    process.env.COZY_URL = 'https://pouet-ecolyo.cozygrandlyon.cloud/'
    const reply = isDev()
    expect(reply).toBe(false)
  })
  it('should return true for alpha', () => {
    // Set the variables
    process.env.COZY_URL = 'https://pouet.cozy.self-data.alpha.grandlyon.com/'
    const reply = isDev()
    expect(reply).toBe(true)
  })
})
