const { cozyClient } = require('cozy-konnector-libs')
const {
  getAccount,
  saveAccountData,
  getAccountForDelete,
} = require('../../src/requests/cozy')

const mockUpdateOrCreate = jest.fn()

describe('getAccount', () => {
  it('should find account with provided ID', async () => {
    const spy = jest.spyOn(cozyClient.data, 'findAll')
    spy.mockResolvedValueOnce([
      {
        _id: '123456',
        account_type: '123456',
        auth: {
          address: '12 rue du pouet',
          city: 'Lyon',
          firstname: 'Jean',
          lastname: 'POUET',
          pointId: '1234567891234567',
          postalCode: '69007',
        },
      },
      { _id: '1111111', account_type: '1111111' },
    ])
    const account = await getAccount('123456')
    expect(account).toEqual({
      _id: '123456',
      account_type: '123456',
      auth: {
        address: '12 rue du pouet',
        city: 'Lyon',
        firstname: 'Jean',
        lastname: 'POUET',
        pointId: '1234567891234567',
        postalCode: '69007',
      },
    })
  })
})
describe('getAccountForDelete', () => {
  it('should find account with provided ID', async () => {
    const spy = jest.spyOn(cozyClient, 'fetchJSON')
    spy.mockResolvedValueOnce(
      {
        _id: '123456',
        account_type: '123456',
        auth: {
          address: '12 rue du pouet',
          city: 'Lyon',
          firstname: 'Jean',
          lastname: 'POUET',
          pointId: '1234567891234567',
          postalCode: '69007',
        },
      },
      { _id: '1111111', account_type: '1111111' }
    )
    const account = await getAccountForDelete('123456', '789456')
    expect(account).toEqual({
      _id: '123456',
      account_type: '123456',
      auth: {
        address: '12 rue du pouet',
        city: 'Lyon',
        firstname: 'Jean',
        lastname: 'POUET',
        pointId: '1234567891234567',
        postalCode: '69007',
      },
    })
  })
})

describe('saveAccountData', () => {
  jest.mock('cozy-konnector-libs', () => ({
    updateOrCreate: () => mockUpdateOrCreate(),
  }))

  it('should save data to account', async () => {
    const spy = jest.spyOn(cozyClient.data, 'findAll')
    spy.mockResolvedValueOnce([
      {
        _id: '123456',
        account_type: '123456',
        auth: {
          address: '12 rue du pouet',
          city: 'Lyon',
          firstname: 'Jean',
          lastname: 'POUET',
          pointId: '1234567891234567',
          postalCode: '69007',
        },
      },
      { _id: '1111111', account_type: '1111111' },
    ])
    mockUpdateOrCreate.mockResolvedValueOnce({
      _id: '1111111',
      account_type: '1111111',
      data: { name: 'pouet' },
    })
    const account = await saveAccountData('1111111', { name: 'pouet' })
    expect(account[0].data).toEqual({ name: 'pouet' })
  })
})
